package elaprendiz.estructuras.funciones;

import elaprendiz.graficos.funciones.Funcion;

import elaprendiz.graficos.imagenes.ObjetoImagen;
import elaprendiz.estructuras.nodos.Nodo;

import elaprendiz.estructuras.LienzoBinario;

public class Resaltar extends Funcion {

  ///////////////////////////////////
  // Maximum time to resaltado node.

  final static int TIEMPOMAX = 20;

  ///////////////////////////////////
  // Timer used to tally total high-
  // light time.

  private int contador = 0;

  ///////////////////////////////////
  // Reference to resaltado node

  private ObjetoImagen resaltado;

  ///////////////////////////////////
  // Reference to EstructuraLienzo
  // so that resaltado node can be
  // removed when function ends

  private LienzoBinario lienzo;


  public Resaltar(Nodo node, LienzoBinario canvas) {
    this.lienzo   = canvas;

    ///////////////////////////////////
    // Create a new resaltado over the
    // requested node and insert into
    // EstructuraLienzo to be drawn.

    resaltado = new ObjetoImagen(node.origin(), canvas.frame, 
				   "HighLight");
    canvas.addNode(resaltado);
  }

  public void performFuncion() {
    if (contador == TIEMPOMAX) {

      setChanged();
      notifyObservers();

      lienzo.removeNode(resaltado);
      terminado = true;

    } else
      contador++;
  }
}
